INTEL_82596	EQU	01h
INTEL_82557	EQU	02h
CHIP	= INTEL_82596
;CHIP	= INTEL_82557

AUTO_CONNECTOR  equ     0
TPE_CONNECTOR   equ     1
BNC_CONNECTOR   equ     2
AUI_CONNECTOR   equ     3

TPE				EQU		10h
BNC				EQU		20h
AUI				EQU		30h

; Action command bits
EL_BIT		EQU	8000h
S_BIT		EQU	4000h
INT_BIT		EQU	2000h
IA_SETUP	EQU	0001h
CONFIG_CMD	EQU	0002h
MULTI_ADD	EQU	0003h
TRANSMIT	EQU	0004h
TDR_CMD		EQU	0005h
	LNK_OK		EQU	8000h
; debug
	TX_THRESHOLD	EQU	4h
	TX_EOF_BIT		EQU	8000h
DUMP		EQU	0006h
DIAGNOSE	EQU	0007h

; Receive frame status in the RFD
SHORT_FRAME_BIT	EQU	0080h
OVER_RUN_BIT	EQU	0100h
RESOURCES_BIT	EQU 0200h
ALIGN_BIT		EQU	0400h
CRC_BIT			EQU	0800h
LENGTH_BIT		EQU 1000h
RX_OK			EQU 2000h
RFD_PREFETCH	EQU 4000h
RFD_DONE_BIT	EQU 8000h

RBD_PREFETCH	EQU 4000h

COUNT_VALID		EQU	4000h
EOF_BIT			EQU 8000h		; End of frame marker for RBD

C_DONE_BIT		EQU	8000h
FLEXIBLE_MODE	EQU	0008h


RBD_COUNT		EQU		10h
RFD_COUNT		EQU		12h		; More than RBD so that we don't run out
SIZE_ONE_DATA_BUFF	EQU	100h

LOAD_PORT	MACRO port_param
	mov		dx, base_addr
	if port_param NE 0
		add		dx, port_param
	endif
	port_no	= port_param
	ENDM

SET_PORT	MACRO port_param
	if port_param - port_no EQ 1
		inc	dx
	else
		if port_param - port_no EQ -1
			dec	dx
		else
			if port_param - port_no NE 0
				add	dx,port_param - port_no
			endif
		endif
	endif
	port_no	= port_param
	ENDM

write_eeprom_bit	MACRO
	out		dx, al
 	or		al, EESK				; Set the eeprom strobe
	out		dx,	al					; Write rising edge of strobe to eeprom
	and		al, NOT EESK			; Clear the eeprom strobe
	out		dx,	al					; Write falling edge of strobe to eeprom
	ENDM

read_eeprom_bit	MACRO
	mov		al, EECS OR EESK
	out		dx,	al					; Write rising edge of strobe to eeprom
	in		al, dx					; Get the data bit
	mov		bl,	al					; Place the result in bl
	mov		al, EECS				; Clear the eeprom strobe
	out		dx,	al					; Write falling edge of strobe to eeprom
	ENDM

stall	macro
	push	ax
	in		al, 61h
	in		al, 61h
	in		al, 61h
	pop		ax
	endm

	MULTI_IA		EQU	2h
	MATCH_ID		EQU	3h
	MATCH_ALL		EQU	4h
	MATCH_BRDCAST	EQU	5h

